<?php
/*	Esprit Badge Info
	Stephanie Mitchell, 15 September, 2013
	This is the URL in the QR code on attendee badges.
	It returns an array with a CSS class code ("stop", "go" etc.) and an HTML
	string to be displayed.
	It also enters a record in the regybphoto table with the confirmation
	number, registration status and the current year.

*/
	require_once "{$_SERVER['DOCUMENT_ROOT']}/setpaths.php";
	require_once ".config.php";
	require_once "mysql_utilities.php";
	require_once ".regconnect.php"; // hostname, ID and password
// 	ini_set('display_startup_errors',1);
// 	ini_set('display_errors', 1);
//	error_reporting(-1);
// print_r(ybphotocheckin('123456','testing'));
function ybphotocheckin($id, $heading = '') {

	$testing = false;
	$init = false;
	if (isset($_REQUEST['mode'])) {
		$testing = ($_REQUEST['mode'] == 'test');
		$init = ($_REQUEST['mode'] == 'init');
	}
	$cookie = $_COOKIE['espritbadgereader'];
	
	$error_string = "<h2>Scan Error</h2><h1>Please rescan</h1>";

	if (!$cookie) {
		return array('type' => 'stop',
			'content' => "$error_string<h3 class=\"message\">Unassigned function.</h3>");
	}
	$id = (isset($_REQUEST['id']) ? $_REQUEST['id'] : false);
	
	if ($init) {
		print '<body class="wait"><h1>Initialising. Please wait. Your scanner will start shortly.</h1>';
	} elseif (!$id) {
		return array('type' => 'stop',
			'content' => "$error_string<h3 class=\"message\">Missing ID number.</h3>");
	} else {
		/*
			Get participant info
		*/

		global $db;

		$db = get_regconnect('Normal');

		$GLOBALS['dbConnect'] = mysqli_connect($db['hn'], $db['un'], $db['pw'], $db['db']) or show_error(__FUNCTION__ . ": Couldn't connect to database server: " . mysqli_error($GLOBALS['dbConnect']));

		$sql = "SELECT firstnamepref, lastnamepref, confirmation_no, reg_status
			FROM reg
			WHERE concat('{$GLOBALS['esprit_yy']}', badge_code)='$id'";
	// 	print 'Final SQL query: '.$sql; realpath(
		$result = mysqli_query($GLOBALS['dbConnect'], $sql) or show_error('Database error on participant status query: '.mysqli_error($GLOBALS['dbConnect']).'; query='.$sql);
		$row = mysqli_fetch_assoc($result);
		$message = '';	//	Check status for eligibility
		if (!$row) {
			$reg_status = 'No Badge';	//	No record of this badge
		} else {
			$reg_status = $row['reg_status'];
		}


		switch (true) {
		case ($reg_status == 'No Badge') :	//	No such badge (maybe scanning
											//	old or stolen or lost one)
			$message = 'Badge unregistered or ineligible.';
			$bg = 'stop';
			$process = false;
			break;

		case (empty($id)) :
			$message = 'Missing badge code. Cannot check in.';
			$bg = 'stop';
			$process = false;
			break;

		case ($reg_status == 'Checked In') :
			$message = 'OK for Photo.';
			$bg = 'go';
			$process = true;
			break;

		case ($reg_status == 'Paid') :
			$message = 'OK for Photo.';
			$bg = 'go';
			$process = true;
			break;

		case ($reg_status == 'Checked Out') :
			$message = 'Checked OUT!';
			$bg = 'stop';
			$process = false;
			break;

		case ($reg_status == 'Participant Cancelled') :
			$message = 'CANCELLED by Participant!';
			$bg = 'stop';
			$process = false;
			break;

		case ($reg_status == 'Esprit Cancelled') :
			$message = 'CANCELLED by ESPRIT!';
			$bg = 'stop';
			$process = false;
			break;

		case ($reg_status == 'Blocked') :
			$message = 'Participant BLOCKED BY ESPRIT!';
			$bg = 'stop';
			$process = false;
			break;

		case ($reg_status != 'Checked In') :
			$message = 'Not checked in!';
			$bg = 'stop';
			$process = false;
			break;
		}

		$msg = "{$row['firstnamepref']} {$row['lastnamepref']} ({$row['confirmation_no']})";
		$logmsg = $msg . "; badge ID {$id}.";
		if ($process === true) {	//	OK to update ybphoto database

			$sql = "INSERT INTO regybphoto (ybconfirmation, esprit_year, ybstatus)
				VALUES({$row['confirmation_no']}, {$GLOBALS['esprit_year']}, '{$row['reg_status']}')";
			// print 'Final SQL query: '.$sql;
			$result = mysqli_query($GLOBALS['dbConnect'], $sql) or show_error('Database error on checkin processing: '.mysqli_error($GLOBALS['dbConnect']).'; <br /> query='.$sql);

			//	Generate logfile line and create logfile entry

			$sql_escaped = mysqli_real_escape_string($GLOBALS['dbConnect'], $sql);
			Make_Log_Entry($GLOBALS['dbConnect'], "YEARBOOK PHOTO CHECKIN PROCESSED BY QR SCAN: $logmsg");
		} else {
			Make_Log_Entry($GLOBALS['dbConnect'], "YEARBOOK PHOTO CHECKIN QR SCAN FAILED: $message: $logmsg");
		}

	
	/*	Now generate badge display. */

	$bg = isset($bg) ? $bg : 'unset';	//	Did we set a background in all this?
	switch ($bg) {						//	Create status message to match it
	case ('go') : $status_msg = 'GO'; break;
	case ('stop') : $status_msg = 'STOP'; break;
	case ('wait') : $status_msg = 'ALERT'; break;
	case ('alert') : $status_msg = 'ALERT'; break;
	case ('unset') : $status_msg = '???'; break;
	}

	$message = !isset($message) ? 'DISPLAY MESSAGE NOT SET!' : "<h1 class=\"message\">$status_msg</h1><h3 class=\"message\">$message</h3>";

	$display_string = <<<BODY
	<h2>$heading</h2>
	<h1>$msg</h1>
	</tr>
	<h3>Confirmation: $confirmation_no</h3>

BODY;
	return array('type' => $bg,
				'content' => "$display_string $message");
	}
}
?>
