<?php
/*	Esprit Badge Info
	Stephanie Mitchell, 15 September, 2013
	This is the URL in the QR code on attendee badges.
	It returns an array with a CSS class code ("stop", "go" etc.) and an HTML
	string to be displayed.
	The mealxchecked field is reset to mealxfield, thus restoring the functionality (if
	any) of the badge for that meal.

*/
function mealreset($id, $mealnum, $heading = '') {

	require_once "{$_SERVER['DOCUMENT_ROOT']}/setpaths.php";
	require_once ".config.php";
	require_once "mysql_utilities.php";
	require_once ".regconnect.php"; // hostname, ID and password
	//	ini_set('display_startup_errors',1);
	//	ini_set('display_errors',1);
	//	error_reporting(-1);		//	All errors
	$testing = false;
	$init = false;
	if (isset($_REQUEST['mode'])) {
		$testing = ($_REQUEST['mode'] == 'test');
		$init = ($_REQUEST['mode'] == 'init');
	}
	$cookie = $_COOKIE['espritbadgereader'];
	
	$error_string = "<h2>Scan Error</h2><h1>Please rescan</h1>";

	if (!$cookie) {
		return ['type' => 'stop',
			'content' => "$error_string<h3 class=\"message\">Unassigned function.</h3>"];
	}
	$id = (isset($_REQUEST['id']) ? $_REQUEST['id'] : false);
	
	$mealfield = 'meal' . $mealnum;
	$mealfieldchecked = 'meal' . $mealnum . 'checked';

	if ($init) {
		print '<body class="wait"><h1>Initialising. Please wait. Your scanner will start shortly.</h1>';
	} elseif (!$id) {
		return ['type' => 'stop',
			'content' => "$error_string<h3 class=\"message\">Missing ID number.</h3>"];
	}
	/*
		Get participant info
	*/

	global $db;

	$db = get_regconnect('Normal');

	$GLOBALS['dbConnect'] = mysqli_connect($db['hn'], $db['un'], $db['pw'], $db['db']) or show_error(__FUNCTION__ . ": Couldn't connect to database server: " . mysqli_error($GLOBALS['dbConnect']));

	$sql = "SELECT firstnamepref, lastnamepref, confirmation_no, reg_status, reg_covid_flag, $mealfield thismeal, $mealfieldchecked thismealchecked, mealnotes mnotes
		FROM reg
		WHERE concat('{$GLOBALS['esprit_yy']}', badge_code)='$id'
			AND reg_status NOT LIKE '%cancel%'";

// 		print 'Final SQL query: '.$sql;

	$result = mysqli_query($GLOBALS['dbConnect'], $sql) or show_error('Database error on participant meal query: '.mysqli_error($GLOBALS['dbConnect']).'query='.$sql_confirm);
	$row = mysqli_fetch_assoc($result);
	$conf = $row['confirmation_no'];
	$message = '';	//	Check status for eligibility
	if (!$row) {
		$firstnamepref = '';
		$lastnamepref = '';
		$conf = '';
		$thismealchecked = 0;
		$unregistered = true;
	} else {
		$unregistered = false;
		extract($row);	//	REALLY quick and dirty
		$conf = $row['confirmation_no'];
		$message = '';	//	Check status for eligibility
	}

	$cert_valid = true;	//	assume COVID cert is good unless reg record says otherwise
	if (COVID) {
		$cert_valid = check_cert($reg_covid_flag);	//	Get the flag result if checking for COVID
	}
	
	$reset = true;
	
	$process = true;	//	Assume we can process this badge unless following checks fail
	$bg='go';			//	set success background

	switch (true) {
		case ($unregistered):				//	Unregistered (from above)?
			$message = 'Badge unregistered or ineligible.';
			$audiomessage = 'unregistered.mp3';
			$process = false;				//	check failed
			$bg = 'stop';					//	failure background
			break;
		
		case ($reset) :						//	Resetting badge?
			$message = 'Resetting badge. Please rescan.';
			$audiomessage = 'please_rescan.mp3';
			$process = false;				//	reset processing still to do below
			$bg = 'go';						//	success background
			break;

		case ($reg_status != "Checked In") :	//	Validate badge
			$message = 'Not checked in';
			$audiomessage = 'notcheckedin.mp3';
			if ($reg_status != "Paid") {
				$message = 'Not paid';
				$audiomessage = 'notpaid.mp3';
			}
			$process = false;				//	check failed
			$bg = 'stop';					//	failure background
			break;

// 		case (!$cert_valid):	//	Invalid vax cert
// 			$message = 'Vax cert invalid.';
// 			$audiomessage = 'vaxinvalid.mp3';
// 			$process = false;				//	check failed
// 			$bg = 'stop';
// 			break;
// 
// 		case ($cert_valid == 'Exempt') :
// 			$message = 'Vax Exempt.';
// 			$audiomessage = 'vaxexempt.mp3';
// 			$process = true;				//	check succeeded
// 			$bg = 'alert';					//	alert background
// 			break;
// 
// 		case ($thismealchecked <= 0) :
// 			$message = 'Badge use exceeded';
// 			$audiomessage = 'usageexceeded.mp3';
// 			$process = false;				//	check failed
// 			$bg = 'stop';					//	failure background
// 			break;
// 		
// 		case ($mnotes != '') :				//	Special meal?
// 			$message = 'Special meal!';
// 			$audiomesage = 'specialmeal.mp3';
// 			$process = true;				//	check succeeded
// 			$bg = 'alert';					//	alert background
// 			break;
// 		
		default:
			$message = '';
			$audiomessage = 'thankyou.mp3';
			$process = true;
			$bg = 'go';
	}
	
	/* Analysis complete. Now see if we process checkin ($process == true) */
	
	if ($process === true) {				//	Do we process this badge?
		$sql = "UPDATE reg SET $mealfieldchecked=$mealfield
			WHERE confirmation_no=$conf";
		$result = mysqli_query($GLOBALS['dbConnect'], $sql) or show_error('Database error on meal reset query: '.mysqli_error($GLOBALS['dbConnect']).'query='.$sql_confirm);
	}

	/*	Now generate badge display. */

	$display_string = "<h2>$heading</h2>
	<h1>$firstnamepref $lastnamepref</h1>
	</tr>
	<h3>Confirmation: $conf</h3>";
	$msg = "{$firstnamepref} {$lastnamepref} ({$conf}); badge ID {$id}.";
	if ($message === '') {
		Make_Log_Entry($GLOBALS['dbConnect'], "MEAL RESET $heading  QR SCAN SUCCESSFUL: $msg");
	} else {
		Make_Log_Entry($GLOBALS['dbConnect'], "MEAL RESET $heading QR SCAN FAILED: $message: $msg");
	}
	if ($thismealchecked > 0 and $mnotes != '') {	//	Special meal
		$bg = 'alert';
		$message .= "<br />$mnotes<br />$remaining remaining</h2>";
	} elseif ($thismealchecked > 0 and $message == '') {	//	Simple background colouring
		$bg = 'go';
		$message .= "<br />$remaining remaining</h2>";
	}
	return ['type' => $bg, 'content' => "$display_string<h3 class=\"message\">$message</h3>"];
}
?>
