<?php
/*	Esprit Badge Info
	Stephanie Mitchell, 15 September, 2013
	It returns an array with a CSS class code ("stop", "go" etc.) and an HTML
	string to be displayed.
	This function can be used at the registration desk to quickly check in an attendee. It checks payment status and if money is owing (either way) it displays the balance on a red screen. If the attendee is paid up it displays a green screen.
*/
function maincheckin($id, $heading = '') {

	require_once "{$_SERVER['DOCUMENT_ROOT']}/setpaths.php";
	require_once ".config.php";
	require_once "mysql_utilities.php";
	require_once ".regconnect.php"; // hostname, ID and password
	//	ini_set('display_startup_errors',1);
	//	ini_set('display_errors',1);
	//	error_reporting(-1);		//	All errors
	$testing = false;
	$init = false;
	if (isset($_REQUEST['mode'])) {
		$testing = ($_REQUEST['mode'] == 'test');
		$init = ($_REQUEST['mode'] == 'init');
	}
	$cookie = $_COOKIE['espritbadgereader'];
	
	$error_string = "<h2>Scan Error</h2><h1>Please rescan</h1>";

	if (!$cookie) {
		return ['type' => 'stop',
			'content' => "$error_string<h3 class=\"message\">Unassigned function.</h3>"];
	}
	$id = (isset($_REQUEST['id']) ? $_REQUEST['id'] : false);
	
	if ($init) {
		return ['type' => 'wait',
			'content' => "<h1>Initialising. Please wait. Your scanner will start shortly.</h1>"];
	} elseif (!$id) {
		return ['type' => 'stop',
			'content' => "$error_string<h3 class=\"message\">Missing ID number.</h3>"];
	}
	/*	Get participant info */
	

	global $db;
	$db = get_regconnect('Normal');
	$GLOBALS['dbConnect'] = mysqli_connect($db['hn'], $db['un'], $db['pw'], $db['db']) or show_error(__FUNCTION__ . ": Couldn't connect to database server: " . mysqli_error($GLOBALS['dbConnect']));

	$sql = "SELECT firstnamepref, lastnamepref, confirmation_no, reg_status,
			reg_covid_flag, checkinvalid
		FROM reg
		WHERE concat('{$GLOBALS['esprit_yy']}', badge_code)='$id'
			AND reg_status NOT LIKE '%cancel%'";

// 		print 'Final SQL query: '.$sql;

	$result = mysqli_query($GLOBALS['dbConnect'], $sql) or show_error('Database error on participant status query: '.mysqli_error($GLOBALS['dbConnect']).'; query='.$sql);
	$row = mysqli_fetch_assoc($result);
	$conf = $row['confirmation_no'];
	$message = '';	//	Check status for eligibility
	if (!$row) {
		$unregistered = true;
	} else {
		$unregistered = false;
		extract($row);	//	REALLY quick and dirty
	//	Check balance if not marked Paid
		$total_amt = 0;	//	Just in case there are no transactions to total
		if ($reg_status != 'Paid') {
			$sql = "SELECT SUM(amount) total_amt
			FROM regpayment
			WHERE confirmation=$confirmation_no";
// 		print 'Final SQL query: '.$sql;
			$result = mysqli_query($GLOBALS['dbConnect'], $sql) or show_error('Database error on balance query: '.mysqli_error($GLOBALS['dbConnect']).'; query='.$sql);
			$row = mysqli_fetch_assoc($result);
			$message = '';	//	Check status for eligibility
			extract($row);	//	REALLY quick and dirty
		}
		$cert_valid = check_cert($reg_covid_flag);	//	Get the flag result
//	Check if too early to check in
		$temptoday = date("Y-m-d H:i:s");
		if ($checkinvalid > $temptoday) {
			$checkin_msg = "too early";
		}
	}
	switch (true) {
		case ($unregistered):				//	Unregistered (from above)?
			$message = 'Badge unregistered or ineligible.';
			$audiomessage = 'unregistered.mp3';
			$process = false;				//	check failed
			$bg = 'stop';					//	failure background
			break;
		
		case (empty($id)) :
			$message = 'Missing badge code. Cannot check in.';
			$bg = 'stop';
			$process = false;
			break;

		case ($reg_status == 'Checked In') :
			$message = 'Already checked in.';
			$bg = 'alert';
			$process = false;
			break;

// 		case (!$cert_valid):	//	Invalid vax cert
// 			$message = 'Vax cert invalid. Cannot check in.';
// 			$audiomessage = 'vaxinvalid.mp3';
// 			$bg = 'stop';
// 			break;
// 
// 		case ($cert_valid == 'Exempt') :
// 			$message = 'Vax Exempt.';
// 			$audiomessage = 'vaxexempt.mp3';
// 			$process = true;				//	check succeeded
// 			$bg = 'alert';					//	alert background
// 			break;
// 
		case ($reg_status == 'Checked Out') :
			$message = 'Already checked OUT!';
			$bg = 'stop';
			$process = false;
			break;

		case ($reg_status == 'Participant Cancelled') :
			$message = 'CANCELLED by Participant!';
			$bg = 'stop';
			$process = false;
			break;

		case ($reg_status == 'Esprit Cancelled') :
			$message = 'CANCELLED by ESPRIT!';
			$bg = 'stop';
			$process = false;
			break;

		case ($reg_status == 'Blocked') :
			$message = 'Participant BLOCKED BY ESPRIT!';
			$bg = 'stop';
			$process = false;
			break;

		case ($checkin_msg  == "too early") :
			$message = "Can't check in till $checkinvalid!";
			$bg = 'stop';
			$process = false;
			break;

		case ($total_amt == 0) :			//	Paid in full?
			$message = 'Paid in full. Checking in.';
			$bg = 'go';
			$process = true;
			break;
		
		case ($total_amt > 0) :	//	Overpaid?
			$message = "Checking in. Refund OWING: \$$total_amt";
			$bg = 'alert';
			$process = true;
			break;

		case ($total_amt < 0) :
			$total_amt = -$total_amt;
			$message = "Balance OWING: \$$total_amt";
			$bg = 'stop';
			$process = false;
			break;
	}

	/* Analysis complete. Now see if we process checkin ($process == true) */

	$checkin_date = date('Y-m-d H:i:s');	//	For database update and logfile

	if ($process === true) {

		//	Update attendee record

		$sql = "UPDATE reg SET reg_status=\"Checked In\", checkindate=\"$checkin_date\" WHERE confirmation_no=$confirmation_no";
		// print 'Final SQL query: '.$sql;
		$result = mysqli_query($GLOBALS['dbConnect'], $sql) or show_error('Database error on checkin processing: '.mysqli_error($GLOBALS['dbConnect']).'; <br /> query='.$sql);

		//	Verify that it went through

		$sql_confirm = "SELECT lastnamepref, firstnamepref, reg_status, checkindate FROM reg WHERE confirmation_no=$confirmation_no";
//		print 'Final SQL query: '.$sql_confirm;
		$result = mysqli_query($GLOBALS['dbConnect'], $sql_confirm) or show_error('Database error on checkin confirmation: '.mysqli_error($GLOBALS['dbConnect']).'<br /> query='.$sql_confirm);
		$row = mysqli_fetch_assoc($result);
		$firstnamepref = $row['firstnamepref'];
		$lastnamepref = $row['lastnamepref'];

		//	Generate logfile line and create logfile entry

		$msg = "{$row['firstnamepref']} {$row['lastnamepref']} ($confirmation_no) set to {$row['reg_status']} using badge ID {$id}.";
		$sql_escaped = mysqli_real_escape_string($GLOBALS['dbConnect'], $sql);
		Make_Log_Entry($GLOBALS['dbConnect'], "CHECKIN PROCESSED BY QR SCAN: $msg");
	}

	/*	Now generate badge display. */

	$bg = isset($bg) ? $bg : 'unset';	//	Did we set a background in all this?
	switch ($bg) {						//	Create status message to match it
	case ('go') : $status_msg = 'GO'; break;
	case ('stop') : $status_msg = 'STOP'; break;
	case ('wait') : $status_msg = 'ALERT'; break;
	case ('alert') : $status_msg = 'ALERT'; break;
	case ('unset') : $status_msg = '???'; break;
	}

	$message = !isset($message) ? 'DISPLAY MESSAGE NOT SET!' : "<h1 class=\"message\">$status_msg</h1><h3 class=\"message\">$message</h3>";

	$display_string = <<<BODY
	<h2>$heading</h2>
	<h1>$firstnamepref $lastnamepref</h1>
	</tr>
	<h3>Confirmation: $confirmation_no</h3>

BODY;
// 	return ['type' => $bg, 'content' => "$display_string<h3 class=\"message\">$message</h3><audio autoplay><source src=\"sounds/" . SOUNDS_FOLDER . "/$audiomessage\"type=\"audio/mpeg\"></audio>"];
	return ['type' => $bg, 'content' => "$display_string<h3 class=\"message\">$message</h3>"];
}
?>


