<?php
/*	Esprit Badge Info
	Stephanie Mitchell, 15 September, 2013
	It returns an array with a CSS class code ("stop", "go" etc.) and an HTML
	string to be displayed.
	It also increments the attendance count for the event.
	It verifies that the participant badge is registered for the day of the event.

*/
function eventcheckin($id, $c_id, $heading = '') {

	//	ini_set('display_startup_errors',1);
	//	ini_set('display_errors',1);
	//	error_reporting(-1);		//	All errors
	$testing = false;
	$init = false;
	if (isset($_REQUEST['mode'])) {
		$testing = ($_REQUEST['mode'] == 'test');
		$init = ($_REQUEST['mode'] == 'init');
	}
	$cookie = $_COOKIE['espritbadgereader'];
	require_once "{$_SERVER['DOCUMENT_ROOT']}/setpaths.php";
	require_once ".config.php";
	require_once "mysql_utilities.php";
	require_once ".regconnect.php"; // hostname, ID and password
	
	$error_string = "<h2>Scan Error</h2><h1>Please rescan</h1>";

	if (!$cookie) {
		return ['type' => 'stop',
			'content' => "$error_string<h3 class=\"message\">Unassigned function.</h3>"];
	}

	if ($init) {
		print '<body class="wait"><h1>Initialising. Please wait. Your scanner will start shortly.</h1>';
	} elseif (!$id) {
		return ['type' => 'stop',
			'content' => "$error_string<h3 class=\"message\">Missing ID number.</h3>"];
	}

	global $db;

	$db = get_regconnect('Normal');

	$GLOBALS['dbConnect'] = mysqli_connect($db['hn'], $db['un'], $db['pw'], $db['db']) or show_error(__FUNCTION__ . ": Couldn't connect to database server: " . mysqli_error($GLOBALS['dbConnect']));
	
	/*
		Get course weekday info as a fieldname. Note trap for first and last
		Sundays. We need to do this in order to get the fieldname to check
		in reg.
	*/
	global $date;
	$e_start = $date['esprit_start']->format('Y-m-d');
	$e_end = $date['esprit_end']->format('Y-m-d');
// 		show_error("Esprit start: $e_start; Esprit end: $e_end");
	$sql = "SELECT CASE
			WHEN (DATE(resourcedate)=\"$e_start\") THEN \"daysun1\"
			WHEN (DATE(resourcedate)=\"$e_end\") THEN \"daysun2\"
			ELSE concat(\"day\",lcase(LEFT(DAYNAME(resourcedate), 3)))
			END cday,
			IF (resourcealsoadmit IS NOT NULL,
			concat(\"day\",lcase(LEFT(DAYNAME(resourcealsoadmit),3))),'') resourcealsoadmit,
		attendees AS attendees
		FROM regpresenter
		WHERE id = $c_id";
	$result = mysqli_query($GLOBALS['dbConnect'], $sql) or show_error('Database error on event detail query: '.mysqli_error($GLOBALS['dbConnect']).'query='.$sql);
	$row = mysqli_fetch_assoc($result);
	$cday = $row['cday'];
	$cdaytemp = $cday;
// 	show_error("\$cday=$cday");
	$calso = $row['resourcealsoadmit'];	//	We might need to check this later
	$attendees = $row['attendees'];	//	List of who's already in

// print_r($row);

	$sql = "SELECT firstnamepref, lastnamepref, confirmation_no, reg_status, 
	reg_covid_flag, form_type
		FROM reg
		WHERE concat('{$GLOBALS['esprit_yy']}', badge_code)='$id'
			AND $cday=1";

// 	show_error('Final SQL query: '.$sql);

	$result = mysqli_query($GLOBALS['dbConnect'], $sql) or show_error('Database error on event participant query at: ' . __LINE__ . mysqli_error($GLOBALS['dbConnect']).'query='.$sql);
	$row = mysqli_fetch_assoc($result);
	$message = '';	//	Check status for eligibility
	$alternate_day = false;
	if ($row) {		//	Match found, badge is registered
		$unregistered = false;
		extract($row);
	} else {		//	Initial day not matched
		$unregistered = true;	//	Not registered for actual event day
		if ($calso != '') {	//	Alternate day specified!
			$sql = "SELECT firstnamepref, lastnamepref, confirmation_no, reg_status, 
				reg_covid_flag, form_type, $cdaytemp day
			FROM reg
			WHERE concat('{$GLOBALS['esprit_yy']}', badge_code)='$id'
				AND $cdaytemp=1";
			$result = mysqli_query($GLOBALS['dbConnect'], $sql) or
				show_error('Database error on event participant query at: ' . __LINE__ . mysqli_error($GLOBALS['dbConnect']).'query='.$sql);
			$row = mysqli_fetch_assoc($result);
			if ($row) {	//	Alternate found, get data,
				$unregistered = false;
				$alternate_day = true;	//	Force message change
				extract($row);
			}
		}
	}
$cert_valid = check_cert($reg_covid_flag);	//	Get the flag result

$process = true;	//	Assume we can process this badge unless following checks fail
$bg='go';			//	set success background

switch (true) {
	case ($alternate_day):				//	OK for alternate day?
		$message = 'Valid - alternate day.';
		$firstnamepref = '';
		$lastnamepref = '';
		$audiomessage = 'unregistered.mp3';
		$process = true;				//	check succeeded
		$bg = 'alert';					//	alert background
		break;
	case ($unregistered):				//	Unregistered (from above)?
		$message = 'Badge unregistered or ineligible.';
		$firstnamepref = '';
		$lastnamepref = '';
		$audiomessage = 'unregistered.mp3';
		$process = false;				//	check failed
		$bg = 'stop';					//	failure background
		break;
	case ($form_type == 'Ticket'):		//	Is this a ticket? if so, no further
										//	checks required
	case ($reg_status != "Checked In") :	//	Validate badge
		$message = 'Not checked in';
		$audiomessage = 'notcheckedin.mp3';
		if ($reg_status != "Paid") {
			$message = 'Not paid';
			$audiomessage = 'notpaid.mp3';
		}
		$process = false;				//	check failed
		$bg = 'stop';					//	failure background
		break;

// 	case (!$cert_valid):	//	Invalid vax cert
// 		$message = 'Vax cert invalid.';
// 		$audiomessage = 'vaxinvalid.mp3';
// 		$process = false;				//	check failed
// 		$bg = 'stop';					//	failure background
// 		break;
// 
// 	case ($cert_valid == 'Exempt') :
// 		$message = 'Vax Exempt.';
// 		$audiomessage = 'vaxexempt.mp3';
// 		$process = true;				//	check succeeded
// 		$bg = 'alert';					//	alert background
// 		break;
// 
	case (!(strpos($attendees, $confirmation_no . ',') === false)):	//	Already checked in once?
		$message = 'Badge usage exceeded';
		$audiomessage = 'usageexceeded.mp3';
		$process = false;				//	check failed
		$bg = 'stop';					//	failure background
		break;
	
	default:							//	Badge is valid
		$message = 'GO';
		$audiomessage = 'thankyou.mp3';
}

	if ($process === true) {	//	Do we process this badge?
		$sql = "UPDATE regpresenter
			SET reg_count=reg_count+1,
			attendees=concat(attendees, \"$confirmation_no\", ', ')
			WHERE id=$c_id";
		$result = mysqli_query($GLOBALS['dbConnect'], $sql) or show_error('Database error on event count update: '.mysqli_error($GLOBALS['dbConnect']).'query='.$sql);
	}

	//	Create display message
	$display_string = "<h2>$heading</h2>
	<h1>$firstnamepref $lastnamepref</h1>
	</tr>
	<h3>Confirmation: $confirmation_no</h3>";
	$msg = "{$row['firstnamepref']} {$row['lastnamepref']} ({$row['confirmation_no']}); badge ID {$id}.";
	if ($message === '') {
		Make_Log_Entry($GLOBALS['dbConnect'], "EVENT CHECKIN $heading  QR SCAN SUCCESSFUL: $msg");
	} else {
		Make_Log_Entry($GLOBALS['dbConnect'], "EVENT CHECKIN $heading QR SCAN FAILED: $message: $msg");
	}
	if ($message == '') {	//	Simple background colouring
		$bg = 'go';
		$message = 'No message';
	}
	if (!file_exists('sounds/' . SOUNDS_FOLDER . "/$audiomessage")) {	//	Default error sound
		$audiomessage = 'red-alert.mp3';
	}
	return ['type' => $bg, 'content' => "$display_string<h3 class=\"message\">$message</h3><audio autoplay><source src=\"sounds/" . SOUNDS_FOLDER . "/$audiomessage\"type=\"audio/mpeg\"></audio>"];
}
?>
