<?php
/*	Utility functions for badge reader */

function validate_device($testing) {
	global $authorised_devices, $init;
	
	if ($testing) {
		return true;	//	Can test on any device
	}
	if (!is_array($authorised_devices)) {
		return false;	//	Bogus parameter
	}
	foreach ($authorised_devices as $this_dev) {
		if (strpos($_SERVER['HTTP_USER_AGENT'], $this_dev)) {
			return true;	//	Success!
		}
	}
	return false;	//	Scanned all options without success
}

function autologin($id) {

	/*
		Attempt to auto-login a badge. This works by looking up the badge
		info, extracting the email address and then checking the regcontrol
		database for a match with a privilege of "Badge_Control:<classname>". If
		successful, the login cookie for the classname is set and we're away to the races.
		NOTE that this doesn't set the function for the device, only the
		class of functions permitted to this user.
	*/
require_once "{$_SERVER['DOCUMENT_ROOT']}/setpaths.php";
require_once ".regconnect.php"; // hostname, ID and password
	
	global $db;
	
	$db = get_regconnect('Normal');

	$GLOBALS['dbConnect'] = mysqli_connect($db['hn'], $db['un'], $db['pw'], $db['db']) or show_error(__FUNCTION__ . ": Couldn't connect to database server: " . mysqli_error($GLOBALS['dbConnect']));
	/*
		Capture email
	*/
		
	$sql = "SELECT email FROM reg WHERE concat('{$GLOBALS['esprit_yy']}', badge_code)='$id'";
	$result = mysqli_query($GLOBALS['dbConnect'], $sql) or show_error('Database error on autologin validation query: '.mysqli_error($GLOBALS['dbConnect']).'; query='.$sql);
	$row = mysqli_fetch_assoc($result);
	if (is_null($row)) {
		return false;
	}
	$email = $row['email'];
	/*
		Check email against regcontrol. Regcontrol record has a privilege like
		"Badge_Control:privilege". Currently only supports one privilege per
		user.
	*/
	
	$sql = "SELECT email,privileges FROM regcontrol WHERE email='$email' AND privileges LIKE '%Badge_Control%'";
	$result = mysqli_query($GLOBALS['dbConnect'], $sql) or show_error('Database error on autologin authorisation query: '.mysqli_error($GLOBALS['dbConnect']).'; query='.$sql);
	$row = mysqli_fetch_assoc($result);
	mysqli_close($GLOBALS['dbConnect']);
	if (is_null($row)) {
		return false;
	}
	//	We're logged in but no function is selected yet
	$privlist = explode(',', $row['privileges']);	//	Get all privileges
	foreach ($privlist as $item) {
		if (strpos($item, 'Badge') !== FALSE) {
		/*	Find the one that says Badge_Control and get its category. Only the
			first one will be found. */
			$priv = explode(':', $item);
			break;
		}
	}

	if (isset($priv[1])) {	//	Was there actually a category set?
		setcookie('espritbadgereader[class]', $priv[1], time()+3600);
		setcookie('espritbadgereader[scannername]', substr($email, 0, strpos($email, '@')), time()+3600);
// print '<pre>'; print_r($_SERVER); print '</pre>';
// print_r($row); print "\$priv=";print_r($priv);
		return $priv[1];
	} else {
		return false;
	}
}

function get_cookie_values() {

	/*	Get values from espritbadgereader cookie.
		Return false if no cookie or not logged in (i.e. no value in cookie),
		otherwise return class.
	*/
	
	if (isset($_COOKIE['espritbadgereader'])) {
		print 'Cookie value is: ' . $_COOKIE['espritbadgereader']['class'];
		return $_COOKIE['espritbadgereader']['class'];
	}
	return false;	//	No cookie, or no class value in it
}

function get_cookie_scannername() {

	/*	Get scanner user name from espritbadgereader cookie.
		Return false if no cookie or not logged in (i.e. no value in cookie),
		otherwise return class.
	*/
	
	if (isset($_COOKIE['espritbadgereader'])) {
		print 'Cookie value is: ' . $_COOKIE['espritbadgereader']['scannername'];
		return $_COOKIE['espritbadgereader']['scannername'];
	}
	return false;	//	No cookie, or no class value in it
}

function badge_diagnose($id) {

	$testing = false;
	$init = false;
	if (isset($_REQUEST['mode'])) {
		$testing = ($_REQUEST['mode'] == 'test');
		$init = ($_REQUEST['mode'] == 'init');
	}

	$cookie = $_COOKIE['espritbadgereader'];	
	$error_string = "<h2>DIAGNOSE</h2><h1>Please rescan</h1>";
	$id = (isset($_REQUEST['id']) ? $_REQUEST['id'] : false);
	$live = !$testing;
	$error_string .= "$error_string<div class=\"message\"<p>This device returns \$_SERVER['HTTP_USER_AGENT']= \"" . $_SERVER['HTTP_USER_AGENT'] ."\"</p>";
	$error_string .= 'PHP Version:'.phpversion().'</p>';

	if (validate_device($testing)) {
		$error_string .="<p>This is a VALID device.</p>";
	} else {
		$error_string .= "<p>This is NOT a valid device<br />";
// die(__FILE__.':'.__FUNCTION__.':'.__LINE__. ":$error_string");
	}
	$error_string .= $testing ? 'TEST MODE is ON<br />' : 'TEST MODE is OFF<br />';
	$error_string .= "This badge ID is $id<br />";
	$error_string .= 'Scanner class = ' . $_COOKIE['espritbadgereader']['class'] . '<br />';
	$error_string .= 'Scanner username = ' . $_COOKIE['espritbadgereader']['scannername'] . '<br />';
	$error_string .= '</div>';
	return ['type' => 'wait',
		'content' => $error_string];
}

function check_cert($cert) {

	/*	Check a COVID vaccination cert. This simply examines the value passed from the
		database to decide if we accept it or not, and returns true (we accept it) or
		false (we don't).
	*/
	return true;
	
// 	if (in_array($cert, ['Verified', 'Exempt', 'NA'])) {	//	The only valid values
// 		return $cert;
// 	} else {
// 		return false;
// 	}

}

function logout() {

	/*	Delete all espritbadgereader cookies, thus logging out. */
	foreach ($_COOKIE['espritbadgereader'] as $name => $value) {
		setcookie("espritbadgereader[$name]", '', time()-3600);
	}
	mysqli_close($GLOBALS['dbConnect']);	//	Make sure we're disconnected
	print_screen('wait', '<h3>Logged out.</h3><p>Please scan an authorised badge to login again.</p>', HIDE_CHANGE);
}

function print_screen($type, $content, $show_change = true) {
	global $esprit_year;
	/*	Print the response screen. Start with some cache control headers */
	
	Header("Cache-Control: must-revalidate,max-age=0,no-cache,no-store");
	Header("Expires: -1");

	print "
	<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">
	<html xmlns=\"http://www.w3.org/1999/xhtml\">
	<head>
	<meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\" />
	<title>Esprit $esprit_year Badge App</title>
	<link rel=\"stylesheet\" href=\"styles.css\" type=\"text/css\">
	</head>";
	/*	Print the parameters given */
	print "<body class=\"$type\">$content";
	//	print '<pre>';print_r($_SERVER);print '</pre>';
	if ($show_change) {
		print '<br /><a style="font-size:1.5em" href="setfunction.php">[Change Function]</a><br />';
	}
	print '<div class="badge_id">';
	$classcookie = array_key_exists('cookie', $_COOKIE) ? $_COOKIE['espritbadgereader']['class'] : null;
	$namecookie = array_key_exists('cookie', $_COOKIE) ? $_COOKIE['espritbadgereader']['scannername'] : null;

	print "Scanner class = '$classcookie'<br />";
	print "Scanner username = '$namecookie'<br />";
	print '</div></body></html>';
}

function show_error($message) {	//	Display database error messages nicely
	global $esprit_year;
	/*	Print the response screen. Start with some cache control headers */
	
	Header("Cache-Control: must-revalidate,max-age=0,no-cache,no-store");
	Header("Expires: -1");

	print "
	<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">
	<html xmlns=\"http://www.w3.org/1999/xhtml\">
	<head>
	<meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\" />
	<title>Esprit $esprit_year Badge App ERROR</title>
	<link rel=\"stylesheet\" href=\"styles.css\" type=\"text/css\">
	</head>";
	/*	Print the parameters given */
	print "<body class=\"stop\"><h2>PROGRAM ERROR</h2>$message";
	//	print '<pre>';print_r($_SERVER);print '</pre>';
	if ($show_change) {
		print '<br /><a href="setfunction.php">[Change Function]</a><br />';
	}
	print '</body>
	</html>';
	show_error;
}

?>